package gov.va.med.domain.model;


import java.util.Date;



public class Prescription extends DomainObject 
{
	
    private Long    _prescriptionIdSeq;
    private Long    _userIdSeq;
    private Long    _institutionId;
    private String  _facilityName;
    private String  _icn;
    
    private Integer _numRefill;
    private Float _quantity;
    private Integer _daysSupply;
    private Integer _division;
    private Integer _mhvStatus;

    private Date    _issueDate;
    private Date    _lastFillDate;
    private Date    _releaseDate;
    private Date    _expirationOrCancelDate;
    private Date    _mhvStatusDate;

    private String  _prescriptionNum;
    private String  _placeOrderNum;
    private String  _ien;
    private String  _providerId;
    private String  _providerFirstName;
    private String  _providerLastName;
    private String  _drugName;
    private String  _drugClass;
    private String  _sig;
    private String  _remarks;
    private String  _mailOrWindow;
    private String  _divisionName;
    private String  _pharmacyStatus;

    private String  _status;
    private String  _statusDesc;
    
    private String _refillStatus;
    private Date   _updatedDate;
    private boolean _refillable;
    private boolean _valid;
    private String _vistaRequestStatus;
    
    public Long getPrescriptionIdSeq()                      {return _prescriptionIdSeq;}
    public Long getUserIdSeq()                              {return _userIdSeq;}
    public Long getInstitutionId()                          {return _institutionId;}
    public String getIcn()                                  {return _icn;}
    

    public Integer getNumReFill()                           { return _numRefill;}
    public Float getQuantity()                            { return _quantity;}
    public Integer getDaysSupply()                          { return _daysSupply;}
    public Integer getDivision()                            { return _division;}
    public Integer getMhvStatus()                           { return _mhvStatus;}

    public Date    getIssueDate()                           { return  _issueDate;}
    public Date    getLastFillDate()                        { return  _lastFillDate;}
    public Date    getReleaseDate()                         { return  _releaseDate;}
    public Date    getExpirationOrCancelDate()              { return  _expirationOrCancelDate;}
    public Date    getMhvStatusDate()                       { return  _mhvStatusDate;}


    public String  getPrescriptionNum()                     { return _prescriptionNum; }
    public String  getPlaceOrderNum()                       { return _placeOrderNum;}
    public String  getIen()                                 { return _ien; }
    public String  getProviderId()                          { return _providerId; }
    public String  getProviderFirstName()                   { return _providerFirstName; }
    public String  getProviderLastname()                    { return _providerLastName; }
    public String  getDrugName()                            { return _drugName;}
    public String  getDrugClass()                           { return _drugClass;}
    public String  getSig()                                 { return _sig;}
    public String  getRemarks()                             { return _remarks;}
    public String  getMailOrWindow()                        { return _mailOrWindow;}
    public String  getDivisionName()                        { return _divisionName;}
    public String  getPharmacyStatus()                      { return _pharmacyStatus;}

    public String  getStatus()                              { return _status;}
    public String  getStatusDesc()                          { return _statusDesc;}
    public String  getRefillStatus()                       { return _refillStatus;}
    public Date    getUpdatedDate()                          { return _updatedDate; }
    public boolean getRefillable()                           { return _refillable; }
    public String  getFacilityName()                        {return _facilityName;}
    public String  getVistaRequestStatus()                  {return _vistaRequestStatus;}
    
    public void setPrescriptionIdSeq(Long value)            {_prescriptionIdSeq=value;}
    public void setUserIdSeq(Long value)                    {_userIdSeq=value;}
    public void setInstitutionId(Long value)                {_institutionId=value;}
    public void setIcn(String value)                        {_icn=value;}
    public void setNumReFill(Integer value)                 { _numRefill=value;}
    public void setQuantity(Float value)                  { _quantity=value;}
    public void setDaysSupply(Integer value)                { _daysSupply=value;}
    public void setMhvStatus(Integer value)                  { _mhvStatus=value;}

    public void setIssueDate(Date value)                    { _issueDate=value;}
    public void setLastFillDate(Date value)                  { _lastFillDate=value;}
    public void setReleaseDate(Date value)                  { _releaseDate=value;}
    public void setExpirationOrCancelDate(Date value)       { _expirationOrCancelDate=value;}
    public void setMhvStatusDate(Date value)                { _mhvStatusDate=value;}

    public void setPrescriptionNum(String value)            { _prescriptionNum=value;}
    public void setPlaceOrderNumber(String value)           { _placeOrderNum=value;}
    public void setIen(String value)                        { _ien=value; }
    public void setProviderId(String value)                 { _providerId=value; }
    public void setProviderFirstName(String value)          { _providerFirstName=value; }
    public void setProviderLastName(String value)           { _providerLastName=value; }
    public void setDrugName(String value)                   { _drugName=value;}
    public void setDrugClass(String value)                  { _drugClass=value;}
    public void setSig(String value)                        { _sig=value;}
    public void setRemarks(String value)                    { _remarks=value;}
    public void setMailOrWindow(String value)               { _mailOrWindow=value;}
    public void setDivision(Integer value)                   { _division=value;}
    public void setDivisionName(String value)               { _divisionName=value;}
    public void setPharmacyStatus(String value)             { _pharmacyStatus=value;}

    public void setStatus(String value)                     { _status=value;}
    public void setStatusDesc(String value)                 { _statusDesc=value;}
    public void setRefillStatus(String value)              { _refillStatus=value;}
    public void setUpdatedDate(Date value)                   { _updatedDate=value; }
    public void setRefillable(boolean value)                {_refillable = value;}
    public void setFacilityName(String value)               {_facilityName = value;}
    public void setVistaRequestStatus(String value)         {_vistaRequestStatus = value;}
    /**
	 * @return Returns the _valid.
	 */
	public boolean isValid() {
		return _valid;
	}
	/**
	 * @param _valid The _valid to set.
	 */
	public void setValid(boolean _valid) {
		this._valid = _valid;
	}
}